<?php
/**
 * @version		$Id: template.php 253 2009-01-07 23:56:26Z louis $
 * @package		JXtended.Libraries
 * @subpackage	Utilities
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

/**
 * @package		JXtended.Libraries
 * @subpackage	Utilities
 */
class JXTemplate extends JObject
{
	var $_template = null;

	/**
	 * Constructor
	 */
	function __construct( $title = '', $body = '' )
	{
		$this->_template = new JObject;
		$this->setTitle( $title );
		$this->setBody( $body );
	}

	/**
	 * Add a directory where we should search for templates. You may
	 * either pass a string or an array of directories.
	 *
	 * @access	public
	 * @param	string	A path to search.
	 * @return	array	An array with directory elements
	 * @since 1.5
	 */
	function addIncludePath( $path=null )
	{
		static $paths;

		if (!isset($paths)) {
			$paths = array( dirname( __FILE__ ).DS.'table' );
		}

		// just force path to array
		settype($path, 'array');

		if (!empty( $path ) && !in_array( $path, $paths ))
		{
			// loop through the path directories
			foreach ($path as $dir)
			{
				// no surrounding spaces allowed!
				$dir = trim($dir);

				// add to the top of the search dirs
				// so that custom paths are searched before core paths
				array_unshift($paths, $dir);
			}
		}
		return $paths;
	}

	/**
	 * @param	string	The raw string to us
	 */
	function setTitle( $text )
	{
		$this->_template->set( 'title',	(string) $text );
		$this->_template->set( 'title2',(string) $text );
	}

	/**
	 * @param	string	The raw string to us
	 */
	function setBody( $text )
	{
		$this->_template->set( 'body',	(string) $text );
		$this->_template->set( 'body2',	(string) $text );
	}

	/**
	 * @param	string	The name of the form
	 */
	function loadFromDB( $name )
	{
		if ($table	= $this->get( 'table' ))
		{
			$db	= &JFactory::getDBO();
			$query	= 'SELECT title, body' .
					' FROM ' . $db->getEscaped( $table->getTableName() ) .
					' WHERE name = '.$db->Quote( $name );
			$db->setQuery( $query );
			if ($temp = $db->loadObject()) {
				$this->_template->set( 'title',	$temp->title );
				$this->_template->set( 'title2',	$temp->title );
				$this->_template->set( 'body',	$temp->body );
				$this->_template->set( 'body2',	$temp->body );
			}

			return (boolean) $this->_template;
		}
		else {
			return JError::raiseError( 500, 'Table from defined' );
		}
	}

	/**
	 * @param	string	The raw string to us
	 */
	function loadFromFile( $name )
	{
		// TODO
	}

	/**
	 * @return	string
	 */
	function getTitle()
	{
		return $this->_template->get( 'title2' );
	}

	/**
	 * @return	string
	 */
	function getBody()
	{
		return $this->_template->get( 'body2' );
	}

	/**
	 * @param	array
	 * @param	string
	 */
	function mergeArray( $fields, $prefix = '' )
	{
		$temp1	= $this->_template->title2;
		$temp2	= $this->_template->body2;
		foreach ($fields as $k => $v)
		{
			if (is_scalar( $v )) {
				$k		= strtoupper( '{'.$prefix.$k.'}' );
				//echo "<br>str_replace( $k, $v, $temp1 )";
				//echo "<br>str_replace( $k, $v, $temp2 )";
				$temp1	= str_replace( $k, $v, $temp1 );
				$temp2	= str_replace( $k, $v, $temp2 );
			}
		}
		$this->_template->set( 'title2',	$temp1 );
		$this->_template->set( 'body2',		$temp2 );
	}

	/**
	 * @param	object
	 * @param	string
	 */
	function mergeObject( $obj, $prefix = '' )
	{
		if (!is_object( $obj )) {
			return;
		}
		else if (method_exists( $obj, 'getPublicProperties' )) {
			$fields	= $obj->getPublicProperties( true );
		}
		else {
			$fields = JArrayHelper::fromObject( $obj );
		}
		$this->mergeArray( $fields, $prefix );
	}
}
