<?php
/**
 * @version		$Id: usergroup.php 256 2009-01-08 07:28:44Z louis $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jximport('jxtended.form.field');
jximport('jxtended.form.fields.list');

/**
 * JXtended Form Field Type Class for a User Group.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeUserGroup extends JXFieldTypeList
{
	/**
	 * Field type
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_type = 'UserGroup';

	function _getOptions(&$node)
	{
		// Get a database object.
		$db = &JFactory::getDBO();

		// Get the user groups from the database.
		$db->setQuery(
			'SELECT a.id AS value, a.title AS text, COUNT(DISTINCT b.id) AS level' .
			' FROM #__usergroups AS a' .
			' LEFT JOIN `#__usergroups` AS b ON a.left_id > b.left_id AND a.right_id < b.right_id' .
			' GROUP BY a.id' .
			' ORDER BY a.left_id ASC'
		);
		$options = $db->loadObjectList();

		// Pad the option text with spaces using depth level as a multiplier.
		for ($i=0,$n=count($options); $i < $n; $i++)
		{
			$options[$i]->text = str_repeat('&nbsp;&nbsp;',$options[$i]->level).$options[$i]->text;
		}

		// If all usergroups is allowed, push it into the array.
		if ($node->attributes('allow_all') == 'true') {
			array_unshift($options, JHtml::_('select.option', '', JText::_('JX Show All Groups')));
		}

		return $options;
	}
}