<?php
/**
 * @version		$Id: textarea.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jximport('jxtended.form.field');

/**
 * JXtended Form Field Type Class for a textarea input.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeTextarea extends JXFieldType
{
   /**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'Textarea';

	function fetchField($name, $value, &$node, $controlName)
	{
		$id		= str_replace(']', '', str_replace('[', '_', $controlName.'_'.$name));
		$rows	= $node->attributes('rows');
		$cols	= $node->attributes('cols');
		$class	= ($node->attributes('class') ? 'class="'.$node->attributes('class').'"' : 'class="text_area"');

		// convert <br /> tags so they are not visible when editing
		$value	= str_replace('<br />', "\n", $value);

		return '<textarea name="'.$controlName.'['.$name.']" cols="'.$cols.'" rows="'.$rows.'" '.$class.' id="'.$id.'" >'.htmlspecialchars($value).'</textarea>';
	}
}