<?php
/**
 * @version		$Id: color.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

/**
 * Text form field type object
 *
 * @package		JXtended.Libraries
 * @subpackage	Forms
 */
class JXFieldTypeText_Color extends JXFieldTypeText
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'Text';

	function fetchField($name, $value, &$node, $controlName)
	{
		static $init = null;
		if (!$init)
		{
			global $mainframe;
			$url	= $mainframe->isAdmin() ? '../' : '';
			$doc	=& JFactory::getDocument();
			$doc->addScript($url.'libraries/jxpro/assets/js/color.js');
			$init	= true;
		}

		$pickerId = str_replace(']', '', str_replace('[', '_', $controlName.'_'.$name)).'-picker';
		$node->addAttribute('onchange', 'relateColor(\''.$pickerId.'\', this.value);');

		$html = parent::fetchField($name, $value, &$node, $controlName);
		$html .= ' <button type="button" onclick="pickColor(\''.$pickerId.'\')" id="'.$pickerId.'" class="color-picker">...</div>';

		return $html;
	}
}