<?php
/**
 * @version		$Id: file.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jximport('jxtended.form.field');

/**
 * JXtended Form Field Type Class for a file input.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeFile extends JXFieldType
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'File';

	function fetchField($name, $value, &$node, $controlName)
	{
		$this->_parent->_multipart = true;
		$id			= str_replace(']', '', str_replace('[', '_', $controlName.'_'.$name));
		$size		= ($node->attributes('size') ? ' size="'.$node->attributes('size').'"' : '');
		$class		= ($node->attributes('class') ? 'class="'.$node->attributes('class').'"' : 'class="text_area"');
		$onchange	= ($node->attributes('onchange') ? ' onchange="'.$node->attributes('onchange').'"' : '');

		return '<input type="file" name="'.$controlName.'['.$name.']" id="'.$id.'" value="" '.$class.$size.$onchange.' />';
	}
}