<?php
/**
 * @version		$Id: combo.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jximport('jxtended.form.field');

/**
 * JXtended Form Field Type Class for a combobox list.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeCombo extends JXFieldType
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'Combo';

	function _getOptions(&$node)
	{
		$options = array ();
		foreach ($node->children() as $option)
		{
			$val	= $option->attributes('value');
			$text	= $option->data();
			$options[] = JHTML::_('select.option', $val, JText::_($text));
		}
		return $options;
	}

	function fetchField($name, $value, &$node, $controlName)
	{
		$id			= str_replace(']', '', str_replace('[', '_', $controlName.'_'.$name));
		$size		= ($node->attributes('size') ? ' size="'.$node->attributes('size').'"' : '');
		$readonly	= ($node->attributes('readonly') == 'true' ? ' readonly="readonly"' : '');
		$onchange	= ($node->attributes('onchange') ? ' onchange="'.$node->attributes('onchange').'"' : '');
		$class		= ($node->attributes('class') ? 'class="'.$node->attributes('class').'"' : 'class="combobox"');

		$options	= $this->_getOptions($node);

		$html	= '<input type="text" name="'.$controlName.'['.$name.']" id="'.$id.'" value="'.htmlspecialchars($value).'" '.$class.$size.$readonly.$onchange.' />';
		$html	.= '<ul id="combobox-'.$id.'" style="display:none;">';
		foreach ($options as $option) {
			$html .= '<li>'.$option->text.'</li>';
		}
		$html	.= '</ul>';

		JHTML::_('behavior.combobox');

		return $html;
	}
}