<?php
/**
 * @version		$Id: category.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		Catalog
 * @copyright	(C) 2008 - 2009 JXtended LLC. All rights reserved.
 * @license		GNU General Public License
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

jimport('joomla.html.html');
jximport('jxtended.form.field');
jximport('jxtended.database.query');

require_once dirname(__FILE__).DS.'list.php';

/**
 * List form field type object
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @since		1.0.11
 */
class JXFieldTypeCategory extends JXFieldTypeList
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'Category';

	function _getOptions(&$node)
	{
		$db			= &JFactory::getDbo();
		$section	= $node->attributes('section');
		if (empty($section)) {
			$section = $this->_parent->getValue('section');
		}

		$query		= new JxQuery;
		$query->select('a.id AS value, a.title AS text');
		$query->from('#__categories AS a');
		$query->where('section = '.$db->quote($section));
		$query->order('a.ordering, a.title');

		$db->setQuery($query->toString());
		$options = $db->loadObjectList();

		if ($node->attributes('allow_none')) {
			array_unshift($options, JHTML::_('select.option', 0, JText::_('JOption_None')));
		}

		return $options;
	}
}