<?php
/**
 * @version		$Id: accesslevel.php 256 2009-01-08 07:28:44Z louis $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jximport('jxtended.form.field');
jximport('jxtended.form.fields.list');

/**
 * JXtended Form Field Type Class for an Access Level.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeAccessLevel extends JXFieldTypeList
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'AccessLevel';

	function _getOptions(&$node)
	{
		$db		= &JFactory::getDBO();
		$query	= new JXQuery;

		$query->select('a.id AS value, a.title AS text');
		$query->select('COUNT(DISTINCT g2.id) AS level');
		$query->from('#__access_assetgroups AS a');
		$query->join('LEFT OUTER', '#__access_assetgroups AS g2 ON a.left_id > g2.left_id AND a.right_id < g2.right_id');
		$query->group('a.id');

		$db->setQuery($query->toString());
		$options = $db->loadObjectList();

		return $options;
	}
}