<?php
/**
 * @version		$Id: sections.php 254 2009-01-07 23:57:23Z louis $
 * @package		JXtended.Libraries
 * @subpackage	Acl.Models
 * @copyright	Copyright (C) 2008 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License
 */

defined('JPATH_BASE') or die;

jimport('joomla.application.component.model');
jximport('jxtended.database.query');

/**
 * Access Control Sections model.
 *
 * @package		JXtended.Libraries
 * @subpackage	Acl.Models
 */
class AclModelSections extends JModel
{
	/**
	 * An array of totals for the lists.
	 *
	 * @access	protected
	 * @var		array
	 */
	var $_totals		= array();

	/**
	 * Array of lists containing items.
	 *
	 * @access	protected
	 * @var		array
	 */
	var $_lists			= array();

	/**
	 * Overridden constructor
	 *
	 * @access	public
	 * @param	array	Configuration array
	 */
	function __construct($config = array())
	{
		parent::__construct($config);

		// Load the type state.
		$this->setState('type.section', 'aco');

		// Load the filter state.
		$this->setState('filter.search', '');

		// Load the list state.
		$this->setState('list.start', 0);
		$this->setState('list.limit', 30);
		$this->setState('list.ordering', 'a.name');
		$this->setState('list.direction', 'ASC');
	}

	/**
	 * Overridden method to get model state variables.
	 *
	 * @access	public
	 * @param	string	$property	Optional parameter name.
	 * @param	mixed	$default	The default value.
	 * @return	mixed	The property where specified, the state object where omitted.
	 * @since	1.0
	 */
	function getState($property = null, $default = null)
	{
		$value = parent::getState($property);
		return (is_null($value) ? $default : $value);
	}

	/**
	 * Method to get a list of items.
	 *
	 * @access	public
	 * @return	mixed	An array of objects on success, false on failure.
	 * @since	1.0
	 */
	function &getItems()
	{
		// Make sure the section type is valid.
		if (!$this->isValidType(strtolower($this->getState('type.section', 'aco')))) {
			$this->setError(JText::_('Invalid ACL Section Type'));
			return false;
		}

		// Get a unique key for the current list state.
		$key = $this->_getStoreId('acl.sections');

		// Try to load the value from internal storage.
		if (!empty ($this->_lists[$key])) {
			return $this->_lists[$key];
		}

		// Load the list.
		$query	= $this->_getListQuery();
		$rows	= $this->_getList($query->toString(), (int)$this->getState('list.start'), (int)$this->getState('list.limit'));

		// Add the rows to the internal storage.
		$this->_lists[$key] = $rows;

		return $this->_lists[$key];
	}

	/**
	 * Method to get a list pagination object.
	 *
	 * @access	public
	 * @return	object	A JPagination object.
	 * @since	1.0
	 */
	function &getPagination()
	{
		jimport('joomla.html.pagination');

		// Create the pagination object.
		$instance = new JPagination($this->getTotal(), (int)$this->getState('list.start'), (int)$this->getState('list.limit'));

		return $instance;
	}

	/**
	 * Method to get the total number of items.
	 *
	 * @access	public
	 * @return	int		The number of items.
	 * @since	1.0
	 */
	function getTotal()
	{
		// Make sure the object type is valid.
		if (!$this->isValidType(strtolower($this->getState('type.section', 'aco')))) {
			$this->setError(JText::_('Invalid ACL Section Type'));
			return false;
		}

		// Get a unique key for the current list state.
		$key = $this->_getStoreId('acl.sections');

		// Try to load the value from internal storage.
		if (!empty ($this->_totals[$key])) {
			return $this->_totals[$key];
		}

		// Load the total.
		$query = $this->_getListQuery();
		$return = (int)$this->_getListCount($query->toString());

		// Check for a database error.
		if ($this->_db->getErrorNum()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Push the value into internal storage.
		$this->_totals[$key] = $return;

		return $this->_totals[$key];
	}

	/**
	 * Valid types
	 */
	function isValidType($type)
	{
		$types = array('acl', 'aro', 'aco', 'axo');
		return in_array($type, $types);
	}

	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @access	protected
	 * @return	string		An SQL query
	 * @since	1.0
	 */
	function _getListQuery()
	{
		// Create a new query object.
		$query = new JXQuery;

		// Get the section type.
		$sType = strtolower($this->getState('type.section', 'aco'));

		// Select all fields from the table.
		$query->select($this->getState('list.select', 'a.*'));
		$query->from('`#__core_acl_'.$sType.'_sections` AS a');

		// Filter the items over the search string if set.
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$query->where('a.name LIKE '.$this->_db->Quote('%'.$search.'%'));
		}

		// Add the list ordering clause.
		$query->order($this->_db->getEscaped($this->getState('list.ordering', 'a.name')).' '.$this->_db->getEscaped($this->getState('list.direction', 'ASC')));

		//echo nl2br($query->toString());
		return $query;
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @access	protected
	 * @param	string		$id		A prefix for the store id.
	 * @return	string		A store id.
	 * @since	1.0
	 */
	function _getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('list.start');
		$id	.= ':'.$this->getState('list.limit');
		$id	.= ':'.$this->getState('list.ordering');
		$id	.= ':'.$this->getState('list.direction');
		$id	.= ':'.$this->getState('filter.search');
		$id	.= ':'.$this->getState('type.section');

		return md5($id);
	}
}
