<?php
/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

/** Import library dependencies */
jimport('joomla.event.plugin');
jimport( 'joomla.filesystem.file' );
jimport( 'joomla.environment.browser' );

/**
 * @version	1.5
 * @author 	Dioscouri Design
 * @link 	http://www.dioscouri.com
 * @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/
class plgSystemJuga extends JPlugin {

	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function plgSystemJuga(& $subject, $config) {
		parent::__construct($subject, $config);
		$this->loadLanguage( '', JPATH_ADMINISTRATOR );
	}
	
	/**
	 * Determines if a bot user agent is in the params of allowed bots
	 * @param $botname
	 * @return unknown_type
	 */
	function _isAllowedBot( $botname )
	{
		$success = false;
		$botname = strtolower( $botname );
		$allowed_bots = strtolower( $this->params->get( 'allowed_bots', '' ) );
		$bots_array = explode( '||', $allowed_bots );
		if (in_array($botname, $bots_array)) {
			$success = true;
		}
		return $success;
	}
	
	/**
	 * 
	 * @return unknown_type
	 */
	function onAfterDispatch()
	{		
		// First check that Juga is installed, and if not, then return
		if ( !JFile::exists( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers'.DS.'juga.php' ) ) {
			return;
		}
		
		// Require Helpers
		jimport( 'joomla.filesystem.folder' );
		$helpersPath = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers';
		$helperFiles = JFolder::files($helpersPath, '\.php$', false, true);
		if (count($helperFiles) > 0) {
			//iterate through the helper files
			foreach ($helperFiles as $helperFile) {
				require_once($helperFile);
			}
		}
		
		// get the user
		$user = JFactory::getUser();
				
		// set the site & query		
		$application = JFactory::getApplication();
		$uri =& JURI::getInstance();
		if ($application->isAdmin()) { 
			$site = 'administrator';
			if (!$uriQuery = $uri->getQuery()) {
				$parsed_url = JugaHelperJuga::getQueryFromRequest( 'administrator' );
			} else {
				parse_str($uri->getQuery(), $parsed_url);
			}
		} else {
			$site = 'site';
			$router = $application->getRouter();
			$parsed_url = $router->parse( $uri );
		}
		$query = $uri->buildQuery($parsed_url);
		
		// import the JUGA CheckRights plugin and get an instance of the dispatcher
		$import = JPluginHelper::importPlugin( 'juga', 'checkrights' );
		$dispatcher	=& JDispatcher::getInstance();
		
		// insert the following line for the URL you want to check access to
		$jugaRights = $dispatcher->trigger( 'checkRights', array( $user->id, $query, $site ) );
		$result = @$jugaRights['0'];
		if (!$result) {
			// Juga CheckRights plugin is not enabled or installed, grant access
			if ($user->get('gid') == '25') {
				echo JText::_("Juga CheckRights plugin is not enabled or installed therefore granting access");
			}
			return true;
		}
		$access = @$result->access;
		
		// $jugaRights[0] returns these values:
		// $jugaRights[0]->access 		// Access Boolean 
		// $jugaRights[0]->error 		// Error Boolean
		// $jugaRights[0]->errorMsg 	// Error Message, 'DEFAULT' if access was undefined and default access level was used
		// $jugaRights[0]->ce_url 		// Error URL for Site Item
		

		// Enable Super Admins to display whether or not access WOULD HAVE BEEN GRANTED for a specified user/non-user
		// Output debugging info if superadmin is logged in and it's activated
			$debug = $this->params->get( 'debug', '0' );
			if ($debug) {
				if ($user->get('gid') == '25') {
					$debugid = $this->params->get( 'debugid', '0' );
					$debugRights = $dispatcher->trigger( 'checkRights', array( $debugid, $query, $site ) );
					$debugAccess = @$debugRights['0'];
					$cleanquery = JugaHelperJuga::_cleanQuery( $query, $site );
					echo "JugaSystemPlugin **Access for Userid {$debugid}: ";
					echo $debugAccess->access ? JText::_("Yes")." " : JText::_("No")." ";
					echo "**Site: {$site} ";
					echo "**URL Query: {$query} ";
					echo "**Site Item Query: {$cleanquery->query} ";
					
				}
			}	

		// Allow restrictions to be disabled on either/both sides of site
		$app = &JFactory::getApplication();	
		if ($app->isAdmin()) {
			$adminside = $this->params->get( 'adminside', '0');
			if (!$adminside) {
				$access = true;
			}			
		} elseif ($app->isSite()) {
			$frontend = $this->params->get( 'frontend', '0');
			if (!$frontend) {
				$access = true;
			}
		}
		
		// check if bots allowed, and if so, if this is a bot in the list of allowed bots
		$browser = &JBrowser::getInstance();
		if ($enable_bots = $this->params->get( 'enable_bots', '0') && $browser->isRobot()) {
			$agent = $browser->getAgentString();
			if ($this->_isAllowedBot($agent)) {
				$access = true;
			}			
		}

		// if no access, fire an error page
		if ( !$access ) {
			// check in needs to occur here.
			JugaHelperJuga::forceCheckin($query);
			// TODO Add this to config page
			$displayErrorMessage = $this->params->get( 'displayErrorMessage', '1' );
			$errorMessage = $this->params->get( 'errorMessage', 'You are not authorized to access the requested resource' );
			if ($displayErrorMessage) {
				$app->redirect( $result->ce_url, JText::_( $errorMessage ), 'message' );
			} else {
				$app->redirect( $result->ce_url );
			}
			return;
		}
	}
}
?>