<?php
/**
 * @version	1.5
 * @package	Juga
 * @author 	Dioscouri Design
 * @link 	http://www.dioscouri.com
 * @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

/** Import library dependencies */
jimport('joomla.event.plugin');

/**
 * Juga Plugin
 *
 * @package		Joomla
 * @subpackage	JFramework
 * @since 		1.5
 */

class plgJugaMenu extends JPlugin {

	/**
	 * Constructor 
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function plgJugaMenu(& $subject, $config)
	{
		parent::__construct($subject, $config);

	}

	/**
	 *
	 *
	 */
	function onDisplayLeftAdminColumnJuga( ) {
		global $mainframe;
		?>
			<div class="module_sidemenu">
	
				<h1><?php echo JText::_( 'Menu' ); ?></h1>
	
				<table class="invisible">
				<tr>
					<td>
						<a href="index.php?option=<?php echo _THISCOMPONENT; ?>"><?php echo JText::_( 'Dashboard' ); ?></a>
					</td>
				</tr>
				<tr>
					<td>
					- - - - - - -
					</td>
				</tr>
				<tr>
					<td>
					<a href="index.php?option=<?php echo _THISCOMPONENT; ?>&controller=groups&task=list"><?php echo JText::_( 'Groups' ); ?></a>
					</td>
				</tr>
				<tr>
					<td>
					<a href="index.php?option=<?php echo _THISCOMPONENT; ?>&controller=users&task=list"><?php echo JText::_( 'Assign Users' ); ?></a>
					</td>
				</tr>
				<tr>
					<td>
					<a href="index.php?option=<?php echo _THISCOMPONENT; ?>&controller=siteitems&task=list"><?php echo JText::_( 'Site Items' ); ?></a>
					</td>
				</tr>
				<tr>
					<td>
					<a href="index.php?option=<?php echo _THISCOMPONENT; ?>&controller=variables&task=list"><?php echo JText::_( 'Variables' ); ?></a>
					</td>
				</tr>
				<tr>
					<td>
					<a href="index.php?option=<?php echo _THISCOMPONENT; ?>&controller=accesscodes&task=list"><?php echo JText::_( 'Access Codes' ); ?></a>
					</td>
				</tr>
				<tr>
					<td>
					- - - - - - -
					</td>
				</tr>			
				<tr>
					<td>
					<a href="index.php?option=<?php echo _THISCOMPONENT; ?>&controller=tools&task=list"><?php echo JText::_( 'Tools' ); ?></a>
					</td>
				</tr>
				<tr>
					<td>
					- - - - - - -
					</td>
				</tr>
				<tr>
					<td>
					<a href="index.php?option=<?php echo _THISCOMPONENT; ?>&controller=config"><?php echo JText::_( 'Configuration' ); ?></a>
					</td>
				</tr>
				</table>
				
				<p></p>
				
			</div>
				
		<?php
		
		return true;
		
	}
}
