<?php
/**
* Author: Dioscouri Design - www.dioscouri.com
* @package Juga
* @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

/** ensure this file is being included by a parent file */
defined( '_JEXEC' ) or die( 'Direct Access to this location is not allowed.' );

/** Import library dependencies */
jimport( 'joomla.plugin.plugin' );
jimport( 'joomla.filesystem.file' );
		
/**
 * Usage:
 * 
 * // install and enable the juga 'checkRights' plugin
 * 
 * // You must import the JUGA CheckRights plugin and get an instance of the dispatcher
 * $import 		= JPluginHelper::importPlugin( 'juga', 'checkrights' );
 * $dispatcher	=& JDispatcher::getInstance();
 * 
 * // insert the following line for the URL you want to check access to
 * // $userid 	= user's id
 * // $query 	= full URL or the query after the '?' of an internal URL
 * // $site 	= 'site' or 'administrator' (optional, assumed to be 'site' if absent)
 * $jugaRights 	= $dispatcher->trigger( 'checkRights', array( $userid, $query, $site ) );
 * 
 * // $jugaRights[0] returns these values:
 * // $jugaRights[0]->access 		// Access Boolean 
 * // $jugaRights[0]->error 		// Error Boolean
 * // $jugaRights[0]->errorMsg 		// Error Message, 'DEFAULT' if access was undefined and default access level was used
 * // $jugaRights[0]->ce_url 		// Error URL for Site Item
 *
 */
class plgJugaCheckRights extends JPlugin {

	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param object $params  The object that holds the plugin parameters
	 * @since 1.5
	 */
	function plgJugaCheckRights( &$subject, $params ) {
		parent::__construct( $subject, $params );
	}

	/**
	 * Checks Rights
	 *
	 * @access public
	 * @param object Details
	 * @return mixed Parameter value
	 */
	function _checkAccessRights( $details ) {
		// use config to determine $success default value--whitelist=true, blacklist=false
		$success = false;
		$args = array();
		
		$return = new stdClass();
		$return->access 	= $success;			// Access Boolean 
		$return->error 		= false;			// Error Boolean
		$return->errorMsg 	= 'DEFAULT';		// Error Message
		$return->ce_url 	= JURI::root(); 	// Error URL for Site Item

		// First check that Juga is installed, and if not, then return
		if ( !JFile::exists( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers'.DS.'juga.php' ) ) {
			$return->error = true;
			$return->errorMsg = JText::_( 'JUGA Not Installed' );
			return $return;
		}

		// Require Helpers
		jimport( 'joomla.filesystem.folder' );
		$helpersPath = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers';
		$helperFiles = JFolder::files($helpersPath, '\.php$', false, true);
		if (count($helperFiles) > 0) {
			//iterate through the helper files
			foreach ($helperFiles as $helperFile) {
				require_once($helperFile);
			}
		}
		$config = &JugaConfig::getInstance();
		$defaultCustomErrorUrl = $config->get( 'default_ce', JURI::root() );
		
		// prepare arguments
		$args['user']	= $details->user; 
		$args['site']	= $details->site;

		// clean the query
		$cleanquery = JugaHelperJuga::_cleanQuery( $details->query, $details->site );
		if (!empty($cleanquery->error)) {
			$return->error = true;
			$return->errorMsg = $cleanquery->errorMsg;
			return $return;
		}

		$args['query']	= $cleanquery->query;		
		$args['option']	= $cleanquery->option; 
		
		// now send the data to juga::rightsCheck, which checks permissions 
		$access = JugaHelperJuga::rightsCheck( $args );
		
		// if error_url_published, set redirect there
		if ( (isset($access->error_url_published)) && (intval($access->error_url_published) == '1') && ($access->error_url) ) 
		{
			// set redirect to custom error URL
			$return->ce_url = $access->error_url;
		} else {
			// set redirect to default error URL
			$return->ce_url = $defaultCustomErrorUrl;
		}
		
		// if user has access
		if (isset($access->access) && $access->access) {
			$return->access = true;
			$return->errorMsg = '';
		}

		return $return;
	}
			
	/**
	 * Checks Rights 
	 *
	 * @param 	int		The user id
	 * @param 	mixed	The query
	 * @param 	mixed	site/administrator
	 */
	function checkRights( $userid, $query, $site='site' ) {		
		$return = '';
		$details = new stdClass();
		$details->user 	= JFactory::getUser( intval($userid) );
		$details->query = $query;
		$details->site 	= $site;

		$return = plgJugaCheckRights::_checkAccessRights( $details );

		return $return;
	}
}