<?php
/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

/** Import library dependencies */
jimport('joomla.event.plugin');

/**
 * @version	1.5
 * @package	Juga
 * @author 	Dioscouri Design
 * @link 	http://www.dioscouri.com
 * @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/
class plgJugaCheckInstallation extends JPlugin {

	/**
	 * Constructor 
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function plgJugaCheckInstallation(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage( '', JPATH_ADMINISTRATOR );
		//$element = strtolower( 'com_Juga' );
		//$this->loadLanguage( $element, JPATH_BASE );
		//$this->loadLanguage( $element, JPATH_ADMINISTRATOR );
	}

	/**
	 * Checks to make sure that this plugin is the one being called by the component
	 *
	 * @access public
	 * @return mixed Parameter value
	 * @since 1.5
	 */
	function _isMe( $row ) 
	{
		$success = false;
		if ($row->element == 'checkinstallation' ) {
			$success = true;
		}
		return $success;
	}
	
	/**
	 * This event is triggered every time Juga's admin-side loads
	 * @return unknown_type
	 */
	function onBeforeDisplayAdminComponentJuga() 
	{
		$success = false;
		
		$config = JugaConfig::getInstance();
		$content_category_exists = $config->get( 'content_category_exists', '0' );
		if (!$content_category_exists) {
			JError::raiseNotice( 'Check Installation', JText::_( "Your installation is not complete.  Please submit the Check Installation Tool in JUGA>>Tools.  Thanks!" ) );	
		}
		
		return $success;
	}

	/**
	 * Tells Juga that this plugin has configuration options
	 * If this function returns false, then the plugin will not display any config options
	 * @param $row
	 * @return unknown_type
	 */
	function onListConfigJuga( $row )
	{
		$success = false;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;	
	}
	
	/**
	 * 
	 * @param $row
	 * @return unknown_type
	 */
	function onDisplayConfigJuga( $row )
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		// Display the configuration options
		echo "<p>";
		echo "<fieldset>";
		echo "<legend>".JText::_( 'Check Installation' )."</legend>";
			echo JText::_("This plugin has no Configuration options");
		echo "</fieldset>";
		echo "</p>";
		
		return $success;		
	}
	
	/**
	 * If this plugin had configuration options, perform the save here
	 * @return unknown_type
	 */
	function onAfterSaveConfig() 
	{
		$success = true;
		return $success;	
	}
	
	/**
	 * Tells Juga that this is a valid tool
	 * @return unknown_type
	 */
	function onListToolsJuga( $row )
	{
		$success = false;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;	
	}
	
	/**
	 * Allows the plugin to prevent itself from being run for whatever reason
	 * @param $row
	 * @return unknown_type
	 */
	function onBeforeDisplayToolJuga( $row ) 
	{
		$success = null;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;		
	}

	/**
	 * After displaying the contents of the plugin, this event is fired
	 * @param $row
	 * @return unknown_type
	 */
	function onAfterDisplayToolJuga( $row ) 
	{
		$success = false;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;		
	}
	
	/**
	 * This displays the contents of the plugin
	 * @param $row
	 * @return unknown_type
	 */
	function onDisplayToolJuga( $row ) 
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		// Display the summary
			echo $this->_onRenderSummary( $row );

		// Display the results after submission
			echo $this->_onRenderSubmit( $row );
			
		return $success;		
	}
	/**
	 * onRenderInputs method
	 *
	 * Method is called as the tabbed area is being rendered.
	 * Returns an array
	 * [0] = the html to be displayed in the tab
	 * [1] = the title of the tab
	 *
	 * @param 	object		holds the listing being viewed
	 * @return 	array		the html to be displayed in this tab & its title
	 */
	function _onRenderSummary( $row ) 
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		$html = "";
		
		$html .= '<div class="note">';
		$html .= '<table>';
			$html .= '
                <tr>
                  <td>
					<p>
				  	'.JText::_( 'DESCJUGATOOLCHECKINSTALLATION' )
		            .'&nbsp;
		            </p>
				  </td>
                </tr>
			';
		$html .= '</table>';
		$html .= '</div>';
		
		return $html;
	}

	/**
	 * _onRenderSubmit method
	 *
	 * @param 	object		holds the listing being viewed
	 * @return 	array		the html to be displayed in this tab & its title
	 */
	function _onRenderSubmit( $row ) 
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		$html = "";
		$response = "";
		
		// Check for request forgeries
		// and that form has been submitted
			if (!JRequest::checkToken()) {
				// jexit( 'Invalid Token' );
				return $success;
			}
		 
		// Add pane, if using tabs
			jimport('joomla.html.pane');
			$tabs = &JPane::getInstance( 'tabs' );		
		
	    // Check if fields exist 
	    // or, here you could call something like an _executeTool() function
			$database = JFactory::getDBO();
			$response = '';
		
			$table = '#__juga_items';
			$field = 'content_category';
			$definition = 'INT(11) NOT NULL';
		
			// if the field doesn't exist, insert it
			$query = " SHOW COLUMNS FROM ".$table. "\n LIKE '".$field."' ";
			$database->setQuery( $query );
			$rows = $database->loadObjectList();
			if ($database->getErrorNum()) {
				$response .= '<p>'.$database->stderr().'</p>';
		    	$success = false;  
			}
		
			if (!$rows && !$database->getErrorNum()) {
		
				$response .= "<p style='color:#FFCC00;'>No column of the name `".$field."` in `".$table."`</p>";
		
				$query = "ALTER TABLE ".$table." ADD `".$field."` ".$definition.";";
				$database->setQuery( $query );
				if (!$database->query()) {
					$response .= '<p>'.$database->stderr().'</p>';
					$response .= "<p style='color:#FFCC00;'>Failed to create `".$field."` in `".$table."`</p>";
			    	$success = false;  
				} else {
					$response .= "<p style='color:#00CC00;' >OK! Column `".$field."` created in `".$table."` </p>";
			    	$success = true;  
				}
		
			} else {
				$response .= '<p>'.JText::_( 'Installation OK' )."</p><p style='color:#00CC00;' >Column `".$field."` already exists in `".$table."` </p>";
		    	$success = true;
			}		

			if ($success) {
				// Update a field in the config database so the system knows this tool has been run
				$row = JTable::getInstance( 'Config', 'Table' );
				$row->load( 'content_category_exists' );
				$row->value = '1';
				if (!$row->store() ) {
					$response .= "<div class='notepi'>".JText::_( "Could not store")." 'content_category_exists'</div>";	
				} else {
					$response .= "<div class='noteg'>".JText::_( "Return to dashboard to hide notice at top of component")."</div>";
				}
			}
			
			// set the response message html
			$html .= '<table class="userlist">';
				$html .= "
	                <tr>
	                  <td>
						<p>
						{$response}
						</p>
					  </td>
	                </tr>
				";
			$html .= '</table>';
			
			
		return $html;
	}
}
