<?php
/**
 * @version	1.5
 * @package	Juga
 * @author 	Dioscouri Design
 * @link 	http://www.dioscouri.com
 * @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

/** Import library dependencies */
jimport('joomla.event.plugin');
jimport('joomla.filesystem.file');

// First check that Juga is installed, and if not, then return
if ( JFile::exists( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers'.DS.'juga.php' ) ) {
	// Require Helpers
	jimport( 'joomla.filesystem.folder' );
	$helpersPath = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers';
	$helperFiles = JFolder::files($helpersPath, '\.php$', false, true);
	if (count($helperFiles) > 0) {
		//iterate through the helper files
		foreach ($helperFiles as $helperFile) {
			require_once($helperFile);
		}
	}	
}

/**
 * Juga Plugin
 *
 * @package		Joomla
 * @subpackage	JFramework
 * @since 		1.5
 */

class plgContentJuga extends JPlugin {

	/**
	 * Constructor
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function plgContentJuga(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$element = strtolower( 'com_Juga' );
		$this->loadLanguage( '', JPATH_ADMINISTRATOR );
		$this->loadLanguage( $element, JPATH_BASE );
	}
	
	/**
	 * Returns a type id
	 * @param mixed Boolean
	 * @param mixed Boolean
	 * @return array
	 */
	function _getId( $value ) {
		
		static $items;
		
		if (!is_numeric($value)) {
			$id = intval( plgContentJuga::_getIdFromTitle( $value ) );
		} else {
			$id = intval($value);
		}
		
		if (!isset($items[$id])) {
			$items[$id] = $id;
		}

		return $items[$id];
	}
		
	/**
	 * Returns a type id
	 * @param mixed Boolean
	 * @param mixed Boolean
	 * @return array
	 */
	function _getIdFromTitle( $title ) {
		$database = &JFactory::getDBO();
		
		$title = trim( strtolower($title) );

		$title_query = " AND LOWER(`title`) = '{$title}' ";
		
		$query = "
			SELECT
				db.id
			FROM
				#__juga_groups AS db
			WHERE 1
				{$title_query}
			LIMIT 1
		";

		$database->setQuery( $query );
		$data = $database->loadResult();

		return $data;
	}
	
	/**
	 *
	 *
	 */
	function _process( $match ) {
		$return = '';
		
		// regex returns this array:
		// $match[0] = {juga JUGA6 || !MANGA6} This is the text to show if in JUGA6 or NOT in MANGA6 {/juga}
		// $match[1] = JUGA6 || !MANGA6
		// $match[2] = This is the text to show if in JUGA6 or NOT in MANGA6

		// if processing match[1] returns true, then return = $match[2]
		// else return = null
		if ( plgContentJuga::_analyze( $match[1] ) ) {
			$return = $match[2];
		}

		return $return;
	}
	
	/**
	 *
	 */
	function _analyze( $statement )
	{
		$return = false;
		
		// regex returns this array:
		// $match[0] = {juga JUGA6 || !MANGA6} This is the text to show if in JUGA6 or NOT in MANGA6 {/juga}
		// $match[1] = JUGA6 || !MANGA6
		// $match[2] = This is the text to show if in JUGA6 or NOT in MANGA6
		
		// first, explode by ||
		// using a for loop, check if any _isTrue
		// when encountering any _isTrue, break for loop and return true

		if ($statement) {
			$items = explode("||", trim($statement) );
			for ($i=0; $i<count($items) && !$return; $i++) {
				$item = $items[$i];
				$return = plgContentJuga::_isTrue( $item );
			}
		}
		
		return $return;
	}
	
	/**
	 *
	 */
	function _isTrue( $item )
	{
		$return = false;
		$results = array();
		$user = JFactory::getUser();

		// explode by &&
		$values = explode("&&", trim($item) );
		
		// for each, check if user is/is-not in group (accounting for !JUGA6)
		for ($i=0; $i<count($values); $i++) {
			$value = $values[$i];
			$negoffset = strpos($value, '!');
			
			// store each result in the array $results
			// by default, result for this one is false
			$results[$i] = false;
			// if no file exists, move on and let this remain = false
			// First check that Juga is installed, and if not, then return
			if ( !JFile::exists( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers'.DS.'juga.php' ) ) {
				break;
			}
		
			if ($negoffset === false) {
				// no "!" found, check if the user is a member of this group ($value), if so, result=true
				$typeid = plgContentJuga::_getId( $value );
				// get user's groups
				$userSubs = JugaHelperJuga::getUsersGroups( $user->id );
				for ($s=0; $s<count($userSubs) && !$results[$i]; $s++) {
					$sub = $userSubs[$s];
					// if user is in group and value doesn't have a ! before it (e.g. JUGA6), then result for this one = true, otherwise false
					if ($sub->id == $typeid) {
						$results[$i] = true;
					}
				}
			} else {
				// "!" found, check if the user is a member of this group($value), and if so, result=true
				$results[$i] = true;
				// trim value of the !
				$value = substr($value, $negoffset+1);
				$typeid = plgContentJuga::_getId( $value );
				// if user is in group and value has ! before it (e.g. !MANGA6) then result for this one = false, otherwise true
				$userSubs = JugaHelperJuga::getUsersGroups( $user->id );
				for ($s=0; $s<count($userSubs); $s++) {
					$sub = $userSubs[$s];
					if ($sub->id == $typeid) {
						$results[$i] = false;
					}
				}
			}
		}
		
		// if all results are true, return true
		if (!in_array(false, $results, true)) {
			$return = true;
		}
		
		return $return;
	}
	
	/**
	 * Example prepare content method
	 *
	 * Method is called by the view
	 *
	 * @param 	object		The article object.  Note $article->text is also available
	 * @param 	object		The article params
	 * @param 	int			The 'page' number
	 */
	function onPrepareContent( &$article, &$params, $limitstart )
	{
		global $mainframe;

		// Check whether the plugin should process or not
		if ( JString::strpos( $article->text, 'juga' ) === false && JString::strpos( $article->text, 'jugaaccess' ) === false )
		{
			return true;
		}

		// Search for this tag in the content
		$regex = "#{jugaaccess(.*?)}(.*?){/jugaaccess}#s";
			// regex returns this array:
			// $match[0] = {jugaaccess JUGA6 || !MANGA6} This is the text to show if in JUGA6 or NOT in MANGA6 {/jugaaccess}
			// $match[1] = JUGA6 || !MANGA6
			// $match[2] = This is the text to show if in JUGA6 or NOT in MANGA6
		
		// process the article text
		$article->text = preg_replace_callback( $regex, array('plgContentJuga', '_process'), $article->text );
		
		// Search for this tag in the content
		$regex = "#{juga(.*?)}(.*?){/juga}#s";
			// regex returns this array:
			// $match[0] = {juga JUGA6 || !MANGA6} This is the text to show if in JUGA6 or NOT in MANGA6 {/juga}
			// $match[1] = JUGA6 || !MANGA6
			// $match[2] = This is the text to show if in JUGA6 or NOT in MANGA6
		
		// process the article text
		$article->text = preg_replace_callback( $regex, array('plgContentJuga', '_process'), $article->text );

	}
}
