<?php
/**
 * @package JUGA
 * @link 	http://www.dioscouri.com
 * @license GNU/GPLv2
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
jimport( 'joomla.filesystem.file' );

if ( JFile::exists( JPATH_SITE.DS.'components'.DS.'com_juga'.DS.'juga.class.php' ) ) {
	require_once( JPATH_SITE.DS.'components'.DS.'com_juga'.DS.'juga.class.php' );
	if (!defined('jugaFileExists')) {
		DEFINE( "jugaFileExists", '1');	
	}
}

/**
 * 
 * @author rafael
 *
 */
class modHiddenByJugaHelper 
{	
	/**
	 * 
	 * @return unknown_type
	 */
	function _isInstalled()
	{
		$success = false;
		
		jimport('joomla.filesystem.file');
		if (JFile::exists(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers'.DS.'juga.php')) {
			// Require Helpers
			jimport( 'joomla.filesystem.folder' );
			$helpersPath = JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers';
			$helperFiles = JFolder::files($helpersPath, '\.php$', false, true);
			if (count($helperFiles) > 0) {
				//iterate through the helper files
				foreach ($helperFiles as $helperFile) {
					require_once($helperFile);
				}
			}
			$success = true;
		}
				
		return $success;
	}
	
	/**
	 * 
	 * @param $item
	 * @return unknown_type
	 */
	function _isTrue( $item ) {
		$return = false;
		$results = array();
		$user = JFactory::getUser();
		
		// explode by &&
		$values = explode("&&", trim($item) );
		
		// for each, check if user is/is-not in group (accounting for !JUGA6)
		for ($i=0; $i<count($values); $i++) {
			$value = $values[$i];
			$negoffset = strpos($value, '!');
			
			// store each result in the array $results
			// by default, result for this one is false
			$results[$i] = false;
			
			// if no file exists, move on and let this remain = false
			if (!modHiddenByJugaHelper::_isInstalled()) { break; }
			
			if ($negoffset === false) {
				
				// no "!" found, check if the user is a member of this group ($value), if so, result=true
				if (modHiddenByJugaHelper::hasJugaAccessLevel( trim($value) ) ) {
					$results[$i] = true; 
				}
			} else {
				// "!" found, check if the user is a member of this group($value), and if so, result=false, otherwise true
				
				$results[$i] = true;
				// trim value of the !
				$value = substr($value, $negoffset+1);
				
				if (modHiddenByJugaHelper::hasJugaAccessLevel( trim($value) ) ) {
					$results[$i] = false; 
				}
			}
		}
		
		// if all results are true, return true
		if (!in_array(false, $results, true)) {
			$return = true;
		}
		
		return $return;
		
	}
	
	/**
	 * 
	 * @param $params
	 * @return unknown_type
	 */
	function checker( $params ) {
		global $mainframe;
		$success = false;
		
		$database = &JFactory::getDBO();
		$my 	= &JFactory::getUser();
		$jugagroups = $params->get( 'jugagroups' );
		$hasaccess = false;
		$negated = false;

		if (!$jugagroups) {
			// if no jugagroups defined, hide the modules
			return $success;
		}
	
		$items = explode(",", trim($jugagroups));
		// if any of the statements is true, return true
		for ($i=0; $i<count($items) && !$success; $i++) {
			$item = $items[$i];
			$success = modHiddenByJugaHelper::_isTrue( $item );
		}
		
		return $success;
	}

	/**
	 * 
	 * @param $level
	 * @param $operator
	 * @return unknown_type
	 */
	function hasJugaAccessLevel($level, $operator=true) {
		global $mainframe;
		
		$database = &JFactory::getDBO();
		$user 	= &JFactory::getUser();
		
		$config = JugaConfig::getInstance();
		$public_juga = $config->get( 'public_juga' );
		
		if ($user->id != 0) {
			if (!$group_id = modHiddenByJugaHelper::_getIdFromTitle( $level )) {
				return false;	
			}
			
			if ($group_id == $public_juga) {
				return true;
			}
			
			$query = " SELECT `user_id` FROM #__juga_u2g WHERE `user_id` = '$user->id' AND `group_id` = '{$group_id}' ";
			$database->setQuery($query);
			$uid = $database->loadResult();
			if ($uid == $user->id) {
				return true;
			}
		} else {
			if (!$group_id = modHiddenByJugaHelper::_getIdFromTitle( $level )) {
				return false;	
			}

			if ($group_id == $public_juga) {
				return true;
			} else {
				return false;
			}
			
		}
		
	}
	
	/**
	 * Returns a type id
	 * @param mixed Boolean
	 * @param mixed Boolean
	 * @return array
	 */
	function _getIdFromTitle( $title ) {
		$database = &JFactory::getDBO();
		
		$title = trim( strtolower($title) );

		$title_query = " AND LOWER(`title`) = '{$title}' ";
		
		$query = "
			SELECT
				db.id
			FROM
				#__juga_groups AS db
			WHERE 1
				{$title_query}
			LIMIT 1
		";

		$database->setQuery( $query );
		$data = $database->loadResult();

		return $data;
	}
}