<?php
/**
* @version		$Id: content.php 9233 2007-10-15 21:14:45Z jinx $
* @package		Joomla.Framework
* @subpackage	Table
* @copyright	Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
* @license		GNU/GPL, see LICENSE.php
* Joomla! is free software. This version may have been modified pursuant
* to the GNU General Public License, and as distributed it includes or
* is derivative of works licensed under the GNU General Public License or
* other free or open source software licenses.
* See COPYRIGHT.php for copyright notices and details.
*/

// Check to ensure this file is within the rest of the framework
defined('JPATH_BASE') or die();


/**
 * PrintPage table
 *
 * @package 	Joomla.Framework
 * @subpackage	Table
 * @since	1.0
 */
class JTablePrintPage extends JTable
{
	/** @var int Primary key */
	var $id				= null;
	/** @var string */
	var $title			= null;
	/** @var string */
	var $alias			= null;
	/** @var int*/
	var $state			= null;
	/** @var string */
	var $content		= null;
	/** @var string */
	var $style			= null;
	/** @var int */
	var $ordering		= null;
	/** @var int */
	var $position		= null;
	/** @var string */
	var $params			= null;

	/**
	* @param database A database connector object
	*/
	function __construct( &$db ) {
		parent::__construct( '#__jeprintpage', 'id', $db );
	}

	/**
	 * Overloaded check function
	 *
	 * @access public
	 * @return boolean
	 * @see JTable::check
	 * @since 1.5
	 */
	function check()
	{
		/*
		TODO: This filter is too rigorous,need to implement more configurable solution
		*/
		if(empty($this->content)) {
			$this->setError(JText::_('Content not empty'));
			return false;
		}
		$this->alias = JFilterOutput::stringURLSafe($this->title);
		return true;
	}
	
}
