<?php
/**
 * @version		$Id: admin.banners.php 7718 2007-06-11 23:00:58Z friesengeist $
 * @package		Joomla
 * @subpackage	Banners
 * @copyright	Copyright (C) 2005 - 2007 Open Source Matters. All rights reserved.
 * @license		GNU/GPL, see LICENSE.php
 * Joomla! is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 */

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );

require_once( JPATH_COMPONENT.DS.'controller.php' );
require_once( JPATH_COMPONENT.DS.'helper.php' );
require_once (JApplicationHelper::getPath('admin_html'));

// Set the table directory
JTable::addIncludePath(JPATH_ADMINISTRATOR.DS.'components'.DS.'com_jeprintpage'.DS.'tables');

// Make sure the user is authorized to view this page
//$user = & JFactory::getUser();
//if (!$user->authorize( 'com_jeprintpage', 'manage' )) {
	//$mainframe->redirect( 'index.php', JText::_('ALERTNOTAUTH') );
//}

$controller = new JePrintPageController();
$task = JRequest::getCmd('task');

switch (strtolower($task))
{
	case 'wizard':
		$controller->execute( $task );
		$controller->redirect();
		break;

	case 'add'  :
	case 'new'  :
		JePrintPageController::editContent(false);
		break;

	case 'edit' :
		JePrintPageController::editContent(true);
		break;

	case 'apply' :
	case 'save' :
		JePrintPageController::saveContent();
		break;

	case 'remove' :
		JePrintPageController::removeContent();
		break;

	case 'publish' :
		JePrintPageController::changeContent(1);
		break;

	case 'unpublish' :
		JePrintPageController::changeContent(0);
		break;

	case 'cancel' :
		JePrintPageController::cancelContent();
		break;

	case 'orderup' :
		JePrintPageController::orderContent(-1);
		break;

	case 'orderdown' :
		JePrintPageController::orderContent(1);
		break;

	case 'copy' :
		JePrintPageController::copyItem();
		break;

	case 'accesspublic' :
		JePrintPageController::accessMenu(0);
		break;

	case 'accessregistered' :
		JePrintPageController::accessMenu(1);
		break;

	case 'accessspecial' :
		JePrintPageController::accessMenu(2);
		break;

	case 'saveorder' :
		JePrintPageController::saveOrder();
		break;

	case 'preview' :
		JePrintPageController::previewContent();
		break;
		
	case 'edit_css' :
		JePrintPageController::editCSS();
		break;

	case 'apply_css' :		
	case 'save_css' :
		JePrintPageController::saveCSS();
		break;	
		
	case 'about' :
		JePrintPageController::viewAbout();
		break;				
		
	default :
		JePrintPageController::viewContent();
		break;
}