<?php
/**
 * @version		$Id: jxform.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

/**
 * Utility class for javascript behaviors
 *
 * @static
 * @package		JXtended.Libraries
 * @subpackage	Forms
 */
class JHTMLJXForm
{
	/**
	 * @param
	 */
	function decorator(&$field, $value = null)
	{
		static $exists = null;

		if ($exists === null) {
			$exists = array();
		}

		// Prime the result
		$result = $value;

		// Get the type from the field if one was supplied
		if ($type = JFilterInput::clean($field->get('decorator'), 'word')) {
			if (!isset($exists[$type])) {
				$exists[$type] = null;

				// check if the file exists
				$path = dirname(__FILE__).DS.'decorators'.DS.$type.'.php';
				if (is_file($path)) {
					require_once($path);

					// check if the class exists
					$className = 'JXDecorator'.ucfirst($type) ;
					if (class_exists($className)) {
						// Cache the classname
						$exists[$type] = $className;
					}
				}
			}

			// The result defaults to the value
			if (($className = $exists[$type])) {
				if (is_callable(array($className, 'render'))) {
					$result = call_user_func(array($className, 'render'), $value, $field->get('decorator_text'), $field->get('decorator_options'));
				}
			}
		}

		return $result;
	}
}