<?php
/**
 * @version		$Id: list.php 379 2009-06-17 07:16:53Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @copyright	Copyright (C) 2008 - 2009 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License <http://www.gnu.org/copyleft/gpl.html>
 * @link		http://jxtended.com
 */

defined('JPATH_BASE') or die;

jimport('joomla.html.html');
jximport('jxtended.form.field');
/**
 * JXtended Form Field Type Class for a select list.
 *
 * @package		JXtended.Libraries
 * @subpackage	Form
 * @version		1.0
 */
class JXFieldTypeList extends JXFieldType
{
   /**
	* Field type
	*
	* @access	protected
	* @var		string
	*/
	var	$_type = 'List';

	function _getOptions(&$node)
	{
		$options = array ();
		foreach ($node->children() as $option)
		{
			$val	= $option->attributes('value');
			$text	= trim($option->data());
			$options[] = JHTML::_('select.option', $val, JText::_($text));
		}
		return $options;
	}

	function fetchField($name, $value, &$node, $controlName)
	{
		$id			= str_replace(']', '', str_replace('[', '_', $controlName.'_'.$name));
		$size		= $node->attributes('size');
		$class		= ($node->attributes('class') ? 'class="'.$node->attributes('class').'"' : 'class="inputbox"');
		$disabled	= $node->attributes('disabled');
		$readonly	= $node->attributes('readonly');
		if ($disabled == 'true')
		{
			$disabled	= ' disabled="disabled"';
			$html		= JHTML::_('select.genericlist', $this->_getOptions($node), $controlName.'['.$name.']', $class.$disabled, 'value', 'text', $value, $id);
		}
		else if ($readonly == 'true')
		{
			$html		= JHTML::_('select.genericlist', $this->_getOptions($node), '', $class.' disabled="disabled"', 'value', 'text', $value, $id)
				. '<input type="hidden" name="'.$controlName.'['.$name.']'.'" value="'.$value.'" />';

/*
			$options	= $this->_getOptions($node);
			$selected	= null;
			foreach ($options as $k => $v) {
				if ($v->value == $value) {
					$selected	= $v->value;
					break;
				}
			}
			$html		= '<input type="text" value="'.$value.'" disabled="disabled" />'
				. '<input type="hidden" name="'.$controlName.'['.$name.']'.'" value="'.$value.'" />';
*/
		}
		else {
			$html	= JHTML::_('select.genericlist', $this->_getOptions($node), $controlName.'['.$name.']', $class, 'value', 'text', $value, $id);
		}
		return $html;
	}
}