<?php
/**
 * @version		$Id: groups.php 179 2008-12-20 00:17:40Z eddieajau $
 * @package		JXtended.Libraries
 * @subpackage	Acl.Models
 * @copyright	Copyright (C) 2008 JXtended, LLC. All rights reserved.
 * @license		GNU General Public License
 */

defined('JPATH_BASE') or die;

jimport('joomla.application.component.model');
jximport('jxtended.database.query');

if (!defined('PUBLIC_USER_GROUP_ID')) {
	define('PUBLIC_USER_GROUP_ID', 28);
}

/**
 * Access Control Groups model.
 *
 * @package		JXtended.Libraries
 * @subpackage	Acl.Models
 */
class AclModelGroups extends JModel
{
	/**
	 * An array of totals for the lists.
	 *
	 * @access	protected
	 * @var		array
	 */
	var $_totals		= array();

	/**
	 * Array of lists containing items.
	 *
	 * @access	protected
	 * @var		array
	 */
	var $_lists			= array();

	/**
	 * Overridden constructor
	 *
	 * @access	public
	 * @param	array	Configuration array
	 */
	function __construct($config = array())
	{
		parent::__construct($config);

		// Load the filter state.
		$this->setState('filter.search', '');
		$this->setState('filter.parent_id', PUBLIC_USER_GROUP_ID);

		// Load the list state.
		$this->setState('list.start', 0);
		$this->setState('list.limit', 30);
		$this->setState('list.ordering', 'a.lft');
		$this->setState('list.direction', 'ASC');
	}

	/**
	 * Overridden method to get model state variables.
	 *
	 * @access	public
	 * @param	string	$property	Optional parameter name.
	 * @param	mixed	$default	The default value.
	 * @return	mixed	The property where specified, the state object where omitted.
	 * @since	1.0
	 */
	function getState($property = null, $default = null)
	{
		$value = parent::getState($property);
		return (is_null($value) ? $default : $value);
	}

	/**
	 * Method to get a list of items.
	 *
	 * @access	public
	 * @return	mixed	An array of objects on success, false on failure.
	 * @since	1.0
	 */
	function &getItems()
	{
		// Get a unique key for the current list state.
		$key = $this->_getStoreId('acl.groups');

		// Try to load the value from internal storage.
		if (!empty ($this->_lists[$key])) {
			return $this->_lists[$key];
		}

		// Load the list.
		$query	= $this->_getListQuery();
		$rows	= $this->_getList($query->toString(), (int)$this->getState('list.start'), (int)$this->getState('list.limit'));

		// Add the rows to the internal storage.
		$this->_lists[$key] = $rows;

		return $this->_lists[$key];
	}

	/**
	 * Method to get a list pagination object.
	 *
	 * @access	public
	 * @return	object	A JPagination object.
	 * @since	1.0
	 */
	function &getPagination()
	{
		jimport('joomla.html.pagination');

		// Create the pagination object.
		$instance = new JPagination($this->getTotal(), (int)$this->getState('list.start'), (int)$this->getState('list.limit'));

		return $instance;
	}

	/**
	 * Method to get the total number of items.
	 *
	 * @access	public
	 * @return	int		The number of items.
	 * @since	1.0
	 */
	function getTotal()
	{
		// Get a unique key for the current list state.
		$key = $this->_getStoreId('acl.groups');

		// Try to load the value from internal storage.
		if (!empty ($this->_totals[$key])) {
			return $this->_totals[$key];
		}

		// Load the total.
		$query = $this->_getListQuery();
		$return = (int)$this->_getListCount($query->toString());

		// Check for a database error.
		if ($this->_db->getErrorNum()) {
			$this->setError($this->_db->getErrorMsg());
			return false;
		}

		// Push the value into internal storage.
		$this->_totals[$key] = $return;

		return $this->_totals[$key];
	}

	/**
	 * Method to build an SQL query to load the list data.
	 *
	 * @access	protected
	 * @return	string		An SQL query
	 * @since	1.0
	 */
	function _getListQuery()
	{
		// Create a new query object.
		$query = new JXQuery;

		// Select all fields from the table.
		$query->select($this->getState('list.select', 'a.*'));
		$query->from('`#__core_acl_aro_groups` AS a');

		// Add the level in the tree.
		$query->select('COUNT(DISTINCT c2.id) AS level');
		$query->join('LEFT OUTER', '`#__core_acl_aro_groups` AS c2 ON a.lft > c2.lft AND a.rgt < c2.rgt');
		$query->group('a.id');

		// Count the objects in the user group.
		$query->select('COUNT(DISTINCT map.aro_id) AS object_count');
		$query->join('LEFT', '`#__core_acl_groups_aro_map` AS map ON map.group_id=a.id');
		$query->group('a.id');

		// Filter the items over the parent id if set.
		$parent_id = $this->getState('filter.parent_id');
		if ($parent_id !== null && $parent_id > 0) {
			$query->join('LEFT', '`#__core_acl_aro_groups` AS p ON p.id = '.(int)$parent_id);
			$query->where('a.lft > p.lft AND a.rgt < p.rgt');
		}

		// Filter the items over the search string if set.
		$search = $this->getState('filter.search');
		if (!empty($search)) {
			$query->where('a.name LIKE '.$this->_db->Quote('%'.$search.'%'));
		}

		// Add the list ordering clause.
		$query->order($this->_db->getEscaped($this->getState('list.ordering', 'a.lft')).' '.$this->_db->getEscaped($this->getState('list.direction', 'ASC')));

		//echo nl2br(str_replace('#__','jos_',$query->toString())).'<hr/>';
		return $query;
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @access	protected
	 * @param	string		$id		A prefix for the store id.
	 * @return	string		A store id.
	 * @since	1.0
	 */
	function _getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('list.start');
		$id	.= ':'.$this->getState('list.limit');
		$id	.= ':'.$this->getState('list.ordering');
		$id	.= ':'.$this->getState('list.direction');
		$id	.= ':'.$this->getState('filter.search');
		$id	.= ':'.$this->getState('filter.parent_id');

		return md5($id);
	}
}
