<?php
/**
 * @version	1.5
 * @package	Juga
 * @author 	Dioscouri Design
 * @link 	http://www.dioscouri.com
 * @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/

/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

/** Import library dependencies */
jimport('joomla.event.plugin');

require_once( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'helpers'.DS.'juga.php' );

/**
 * Juga Plugin
 *
 * @package		Joomla
 * @subpackage	JFramework
 * @since 		1.5
 */

class plgJugaStatistics extends JPlugin {

	/**
	 * Constructor 
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function plgJugaStatistics(& $subject, $config)
	{
		parent::__construct($subject, $config);

	}

	/**
	 * Juga store user method
	 *
	 * Method is called before user data is stored in the database
	 *
	 * @param 	array		holds the old user data
	 * @param 	boolean		true if a new user is stored
	 */
	function onDisplayLeftAdminColumnJuga( ) {
		global $mainframe;
		$database = &JFactory::getDBO();
	
		$stats = array();
		
		// new today siteitems
			$query = "SELECT COUNT(*) "
			. " FROM #__juga_items "
			. " WHERE created_datetime >= '".gmdate("Y-m-d H:i:s")."' "
			;
		$database->setQuery( $query );
		$stats["siteitems_today"] = $database->loadResult();
	
		// unassigned siteitems
			$query = "SELECT COUNT(*) "
			. " FROM #__juga_items AS i "
			. " LEFT JOIN #__juga_g2i AS g2i ON i.id = g2i.item_id  "
			. " WHERE 1 "
			. " AND g2i.group_id IS NULL "
			;
		$database->setQuery( $query );
		$stats["siteitems_unassigned"] = $database->loadResult();
	
		// total siteitems
			$query = "SELECT COUNT(*) "
			. " FROM #__juga_items "
			;
		$database->setQuery( $query );
		$stats["siteitems_total"] = $database->loadResult();
	
		// unassigned users
		$query = "SELECT COUNT(*) FROM #__users "
		." LEFT JOIN #__juga_u2g ON #__users.id = #__juga_u2g.user_id "
		." WHERE #__juga_u2g.group_id IS NULL "
		;
		$database->setQuery( $query );
		if ($database->getErrorNum()) {
			echo $database->stderr();
		}
		$stats["users_unassigned"] = $database->loadResult();
	
		// total users
		$query = "SELECT COUNT(*) FROM #__users ";
		$database->setQuery( $query );
		$stats["users_total"] = $database->loadResult();
		?>
		
		<div class='noteg'>
			<strong><?php echo JText::_( 'Statistics' ); ?></strong>
			 
			<table class='invisible'>
            
            <?php if ( $num = $stats["siteitems_today"] ) { ?>
			  <tr>
				<td>
					<?php 
						$link = "index.php?option=com_juga&controller=siteitems&order=createddate&order_dir=desc";
					?>
				</td>
				<td>
					<?php 
						echo "<a href='".$link."'>".$num." ".JText::_( 'New Site Items' )."</a>"; 
					?>
				</td>
			  </tr>
              <?php } ?>

            <?php if ( $num = $stats["siteitems_unassigned"] ) { ?>
			  <tr>
				<td>
					<?php 
						$link = "index.php?option=com_juga&controller=siteitems&_group=-2";
					?>
				</td>
				<td>
					<?php 
						echo "<a href='".$link."'>".$num." ".JText::_( 'Unassigned Items' )."</a>"; 
					?>
				</td>
			  </tr>
              <?php } ?>

            <?php if ( $num = $stats["siteitems_total"] ) { ?>              
			  <tr>
				<td>
					<?php 
						$link = "index.php?option=com_juga&controller=siteitems&order=title&order_dir=asc&_group=";
					?>
				</td>
				<td>
					<?php 
						echo "<a href='".$link."'>".$num." ".JText::_( 'Total Items' )."</a>"; 
					?>
				</td>
			  </tr>
              <?php } ?>

            <?php if ( $num = $stats["users_unassigned"] ) { ?>              
			  <tr>
				<td>
					<?php 
						$link = "index.php?option=com_juga&controller=users&group_id=-2";
					?>
				</td>
				<td>
					<?php 
						echo "<a href='".$link."'>".$num." ".JText::_( 'Unassigned Users' )."</a>"; 
					?>
				</td>
			  </tr>
              <?php } ?>

            <?php if ( $num = $stats["users_total"] ) { ?>              
			  <tr>
				<td>
					<?php 
						$link = "index.php?option=com_juga&controller=users&group_id=";
					?>
				</td>
				<td>
					<?php 
						echo "<a href='".$link."'>".$num." ".JText::_( 'Total Users' )."</a>"; 
					?>
				</td>
			  </tr>
              <?php } ?>
              
			</table>
		</div>
	<?php
		
		return true;
		
	}
}
