<?php
/** ensure this file is being included by a parent file */
defined('_JEXEC') or die('Restricted access');

/** Import library dependencies */
jimport('joomla.event.plugin');

/**
 * @version	1.5
 * @package	Juga
 * @author 	Dioscouri Design
 * @link 	http://www.dioscouri.com
 * @copyright Copyright (C) 2007 Dioscouri Design. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
*/
class plgJugaCreateEditingItems extends JPlugin {

	/**
	 * Constructor 
	 *
	 * For php4 compatability we must not use the __constructor as a constructor for plugins
	 * because func_get_args ( void ) returns a copy of all passed arguments NOT references.
	 * This causes problems with cross-referencing necessary for the observer design pattern.
	 *
	 * @param object $subject The object to observe
	 * @param 	array  $config  An array that holds the plugin configuration
	 * @since 1.5
	 */
	function plgJugaCreateEditingItems(& $subject, $config)
	{
		parent::__construct($subject, $config);
		$this->loadLanguage( '', JPATH_ADMINISTRATOR );
		//$element = strtolower( 'com_Juga' );
		//$this->loadLanguage( $element, JPATH_BASE );
		//$this->loadLanguage( $element, JPATH_ADMINISTRATOR );
	}

	/**
	 * Checks to make sure that this plugin is the one being called by the component
	 *
	 * @access public
	 * @return mixed Parameter value
	 * @since 1.5
	 */
	function _isMe( $row ) 
	{
		$success = false;
		if ($row->element == 'createeditingitems' ) {
			$success = true;
		}
		return $success;
	}

	/**
	 * Tells Juga that this plugin has configuration options
	 * @param $row
	 * @return unknown_type
	 */
	function onListConfigJuga( $row )
	{
		$success = false;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;	
	}
	
	/**
	 * 
	 * @param $row
	 * @return unknown_type
	 */
	function onDisplayConfigJuga( $row )
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		// Display the configuration options
		echo "<p>";
		echo "<fieldset>";
		echo "<legend>".JText::_( 'Create Editing Site Items' )."</legend>";
			echo JText::_("This plugin has no Configuration options");
		echo "</fieldset>";
		echo "</p>";
		
		return $success;		
	}
	
	/**
	 * If this plugin had configuration options, perform the save here
	 * @return unknown_type
	 */
	function onAfterSaveConfig() 
	{
		$success = true;
		return $success;	
	}
	
	/**
	 * Tells Juga that this is a valid tool
	 * @return unknown_type
	 */
	function onListToolsJuga( $row )
	{
		$success = false;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;	
	}
	
	/**
	 * Allows the plugin to prevent itself from being run for whatever reason
	 * @param $row
	 * @return unknown_type
	 */
	function onBeforeDisplayToolJuga( $row ) 
	{
		$success = null;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;		
	}

	/**
	 * After displaying the contents of the plugin, this event is fired
	 * @param $row
	 * @return unknown_type
	 */
	function onAfterDisplayToolJuga( $row ) 
	{
		$success = false;
		if ($this->_isMe($row)) {
			$success = true;
		}
		return $success;		
	}
	
	/**
	 * This displays the contents of the plugin
	 * @param $row
	 * @return unknown_type
	 */
	function onDisplayToolJuga( $row ) 
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		// Display the summary
			echo $this->_onRenderSummary( $row );

		// Display the results after submission
			echo $this->_onRenderSubmit( $row );
			
		return $success;		
	}
	/**
	 * onRenderInputs method
	 *
	 * Method is called as the tabbed area is being rendered.
	 * Returns an array
	 * [0] = the html to be displayed in the tab
	 * [1] = the title of the tab
	 *
	 * @param 	object		holds the listing being viewed
	 * @return 	array		the html to be displayed in this tab & its title
	 */
	function _onRenderSummary( $row ) 
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		$html = "";
		
		$html .= '<div class="note">';
		$html .= '<table>';
			$html .= '
                <tr>
                  <td>
					<p>
				  	'.JText::_( 'DESCJUGATOOLCREATEEDITINGITEMS' )
		            .'&nbsp;
		            </p>
				  </td>
                </tr>
			';
		$html .= '</table>';
		$html .= '</div>';
		
		return $html;
	}

	/**
	 * _onRenderSubmit method
	 *
	 * @param 	object		holds the listing being viewed
	 * @return 	array		the html to be displayed in this tab & its title
	 */
	function _onRenderSubmit( $row ) 
	{
		$success = false;
		if (!$this->_isMe($row)) {
			return $success;
		}
		
		$html = "";
		
		// Check for request forgeries
		// and that form has been submitted
			if (!JRequest::checkToken()) {
				// jexit( 'Invalid Token' );
				return $success;
			}	
		 
	    // or, here you could call something like an _executeTool() function
	    	$content = $this->_executeTool();
	    	
	    // output message
	    	$html .= "<ul>";
			$html .= "<li>".JText::_( 'Create Editing Site Items' )."... ";
			$html .= $content['new'] ." ". JText::_( 'New Editing Site Items' ) . '<img src="images/tick.png" /> ';
			$html .= '</li>';
			$html .= '</ul>';
		
		return $html;
	}
	
	/**
	 * syncContent
	 * 
	 * Synchronizes all Content 
	 *
	 * @param array $jugaItems
	 * @param int $defaultGroup
	 * @return int
	 */
	function _executeTool()
	{
		$database = JFactory::getDBO();
		$database->setQuery("SELECT * FROM #__juga_items ORDER BY id");
		$jugaItems = $database->loadObjectList();
		
		$config = &JugaConfig::getInstance();
		$defaultJuga = $config->get( 'default_group_sync', '0' );
		
		JTable::addIncludePath( JPATH_ADMINISTRATOR.DS.'components'.DS.'com_juga'.DS.'tables' );
		
		$database->setQuery("
							SELECT 
								* 
							FROM 
								#__content
							ORDER BY 
								`id` ASC ");
		$existingContents = $database->loadObjectList();
	
		// get options arrays to prevent multiple looping on each component
		// in_array is quicker than recursive foreach
		$siteOptions = array();
		$adminOptions = array();
		$otherOptions = array();
		foreach($jugaItems AS $item ) {
			if ($item->site == 'site') {
				$siteOptions[] = $item->query;
				$siteItems[$item->query] = $item;
			} else if ($item->site == 'administrator') {
				$adminOptions[] = $item->query;
				$adminItems[$item->query] = $item;
			} else {
				$otherOptions[] = $item->query;
				$otherItems[$item->query] = $item;
			}
		}
		$site_new = 0;
		$admin_new = 0;
		$site_update = 0;
		$admin_update = 0;
		$site_deleted = 0;
		$admin_deleted = 0;
		foreach ($existingContents as $content) {
			if (!in_array("option=com_content&id=".$content->id."&task=edit&view=article", $siteOptions)) { 
				// add if not already synced
				$siteItem = JTable::getInstance( 'Item', 'Table' );
				$siteItem->site				= "site";
				$siteItem->site_option		= "com_content";
				$siteItem->query			= "option=com_content&id=".$content->id."&task=edit&view=article";
				$siteItem->type				= "cont";
				$siteItem->created_datetime	= gmdate("Y-m-d H:i:s");
				$siteItem->title			= JugaHelperItem::findTitle(array( 'option' => $siteItem->site_option, 
																	  'string' => $siteItem->query, 
																	  'site' => $siteItem->site	, 
																	  'jugatype' => $siteItem->type	));
				$siteItem->content_category = $content->catid;
				$siteItem->store();
				if ($defaultJuga) {
					JugaHelperItem::addToGroup($siteItem->id, $defaultJuga);
				}
				$site_new++;
			} else {
				// TODO I think we need to preform some kind of search in $siteItems to return the item to be updated
				// if already present then verify and update
				if ($siteItems["option=com_content&id=".$content->id."&task=edit&view=article"]->title !=  $content->title || 
					$siteItems["option=com_content&id=".$content->id."&task=edit&view=article"]->content_category != $content->catid) {
					// if differing titles then update		
					$siteItem = JTable::getInstance( 'Item', 'Table' );
					// TODO Fix this bug -- it's trying to load based on the id number of content
					// TODO when it should use a $siteItem->id
					// TODO for the admin ones as well
					$siteItem->load( (int) $content->id );
					$siteItem->title = $siteItems["option=com_content&id=".$content->id."&task=edit&view=article"]->title;
					$siteItem->content_category = $content->catid;
					$siteItem->store();
					$site_update++;		
				}
				// remove found items to leave only outstanding 
				
				unset($siteOptions[array_search("option=com_content&id=".$content->id."&task=edit&view=article", $siteOptions)]);
			}
			if (!in_array("option=com_content&id=".$content->id."&task=edit&view=article", $adminOptions)) { 
				// add if not already synced
				$adminItem = JTable::getInstance( 'Item', 'Table' );
				$adminItem->site				= "administrator";
				$adminItem->site_option		= "com_content";
				$adminItem->query			= "option=com_content&id=".$content->id."&task=edit&view=article";
				$adminItem->type				= "cont";
				$adminItem->created_datetime	= gmdate("Y-m-d H:i:s");
				$adminItem->title			= JugaHelperItem::findTitle(array( 'option' => $adminItem->site_option, 
																	  'string' => $adminItem->query, 
																	  'site' => $adminItem->site	, 
																	  'jugatype' => $adminItem->type	));
				$adminItem->content_category = $content->catid;
				$adminItem->store();
				if ($defaultJuga) {
					JugaHelperItem::addToGroup($adminItem->id, $defaultJuga);
				}
				$admin_new++;
			} else {
			// if already present then verify and update
				if ($adminItems["option=com_content&id=".$content->id."&task=edit&view=article"]->title !=  $content->title || 
					$adminItems["option=com_content&id=".$content->id."&task=edit&view=article"]->content_category != $content->catid) {
					// if differing titles then update		
					$adminItem = JTable::getInstance( 'Item', 'Table' );
					$adminItem->load( (int) $content->id );
					$adminItem->title = $adminItems["option=com_content&id=".$content->id."&view=article"]->title;
					$adminItem->content_category = $content->catid;
					$adminItem->store();
					$admin_update++;		
				}
				unset($adminOptions[array_search("option=com_content&id=".$content->id."&task=edit&view=article", $adminOptions)]);
			}
		 } 
		 
		return array ('new' => $admin_new + $site_new, 
					  'updated' => $admin_update + $site_update, 
					  'deleted' => $admin_deleted + $site_deleted );
	} // end of function syncContent
	
}
